/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: Profibus_CodeDiag_Public.h 50784 2015-01-14 10:22:46Z mark $

Description:
  This file contains definitions for code diagnosic functionalities

**************************************************************************************/
/*****************************************************************************/
/*! \file
*  Definition file for Diagnostic Functionality by the EtherNet/IP           */
/*****************************************************************************/

/* Prevent multiple inclusion */
#ifndef __PROFIBUS_CODEDIAG_PUBLIC_H
#define __PROFIBUS_CODEDIAG_PUBLIC_H

typedef __TLR_PACKED_PRE struct PROFIBUS_CODE_DIAG_Ttag {
  TLR_UINT32 ulInfoCount;
  TLR_UINT32 ulWarningCount;
  TLR_UINT32 ulErrorCount;
  TLR_UINT32 ulLevel;
  TLR_UINT32 ulCode;
  TLR_UINT32 ulParameter;
  TLR_UINT32 ulLine;
  TLR_STR    abModulName[12];
}__TLR_PACKED_POST PROFIBUS_CODE_DIAG_T;


/*****************************************************************************/
/* Definitions                                                               */
/*****************************************************************************/

/* Global definitions */
/* Diagnosis level */
#define PROFIBUS_CDG_LVL_NONE                    (0)       /*!< Diagnose code do not have a diagnostic level */
#define PROFIBUS_CDG_LVL_INFO                    (1)       /*!< Diagnose is a information                    */
#define PROFIBUS_CDG_LVL_WARNING                 (2)       /*!< Diagnose is a warning                        */
#define PROFIBUS_CDG_LVL_ERROR                   (3)       /*!< Diagnose is a error                          */
#define PROFIBUS_CDG_LVL_FATAL                   (4)       /*!< Diagnose is a fatal error                    */

/* only values 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 are allowed */
#define PROFIBUS_CDG_MAX_ENTRIES                 0x20      /*!< maximal number of diagnostic entries         */

/*****************************************************************************/
/* Structures                                                                */
/*****************************************************************************/

/*****************************************************************************/
/*! Structure of a diagnostic entry                                          */
/*****************************************************************************/
typedef struct PROFIBUS_CDG_ENTRY_Ttag
{
  TLR_UINT32  ulLevel;                                        /*!< 0x00 Diagnostic level                    */
  TLR_UINT32  ulCode;                                         /*!< 0x04 Diagnostic code                     */
  TLR_UINT32  ulParameter;                                    /*!< 0x08 Additional parameter                */
  TLR_UINT32  ulLine;                                         /*!< 0x0C Line of the diagnostic              */
  TLR_UINT8   abModulName[12];                                /*!< 0x10 Modul name of diagnostic            */
} PROFIBUS_CDG_ENTRY_T;

/*****************************************************************************/
/*! Structure of a diagnostic                                                */
/*****************************************************************************/
typedef struct PROFIBUS_CDG_Ttag
{
  PROFIBUS_CODE_DIAG_T *ptDiagInfo;
  TLR_UINT32  ulInfoCnt;                                      /*!< 0x00 Counter of info diagnostics         */
  TLR_UINT32  ulWarningCnt;                                   /*!< 0x04 Counter of warning diagnostics      */
  TLR_UINT32  ulErrorCnt;                                     /*!< 0x08 Counter of error diagnostics        */

  TLR_UINT32  ulLastEntry;                                    /*!< 0x10 Number of last entry at ring buffer */
  PROFIBUS_CDG_ENTRY_T atEntry[ PROFIBUS_CDG_MAX_ENTRIES ];             /*!< 0x14 Ring buffer of diagnostic entries   */
}PROFIBUS_CDG_T;


/*****************************************************************************/
/* Macro Definitions                                                         */
/*****************************************************************************/
#define PROFIBUS_CDG_PUT_CODE_DIAG(ptStruct,ulLevel,ulCode,ulParam)              \
       ProfibusCdgPutCodeDiag( (PROFIBUS_CDG_T *)                 ptStruct,           \
                          (TLR_UINT32)                  ulLevel,            \
                          (TLR_UINT32)                  ulCode,             \
                          (TLR_UINT32)                  ulParam,            \
                          (CONST TLR_CHAR FAR*)         szModulName,        \
                          (TLR_UINT32)                  __LINE__              )



/*****************************************************************************/
/* Prototypes                                                                */
/*****************************************************************************/
void ProfibusCdgPutCodeDiag( PROFIBUS_CDG_T *ptStruct,
                        TLR_UINT32 ulLevel,
                        TLR_UINT32 ulCode,
                        TLR_UINT32 ulParam,
                        CONST TLR_CHAR *szModulName,
                        TLR_UINT32 ulLine );

#endif  /* __PROFIBUS_CODEDIAG_PUBLIC_H */
